/*------------------------------------------------------------------------------*
 * File Name: OC_NAG_ex.h														*
 * Creation: ML 10/12/2005														*
 * Purpose: Origin C Header for ONAG_ex.dll functions (OriginPro only)			*
 * Copyright (c) OriginLab Corp.	2005-2010									*
 *			All Rights Reserved													*
 * 																				*
 * Modification Log:															*
 * GJL 1/29/04 Exclude unneeded NAG header files in Origin 8.0					*
 *	ML 11/10/2005 ORGONAG_DLL													*
 *------------------------------------------------------------------------------*/


#ifndef _OC_NAG_EX_H
#define _OC_NAG_EX_H
/////////////////////////////////////


#pragma message("OC_NAG_ex is included")
/// ML 11/10/2005 ORGONAG_DLL
#ifdef __AFX_H__	   //VC
#ifdef __cplusplus
extern "C"
{
#endif

#else // !__AFX_H__
/// end ORGONAG_DLL
#pragma	dll(ONAG_ex.dll)
/// ML 11/10/2005 ORGONAG_DLL
#endif // !__AFX_H__

/// end ORGONAG_DLL


/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE
#ifdef __AFX_H__	   //VC
// Putting this ifdef here since the repeated measure ANOVA funcs are anyhow not exported.
/// end NEW_NAG_WAVELET_UPDATE

//////////////////////////////////////////////////////////
// Begin RM ANOVA:
/* One-way ANOVA */
int NAGRepeatedANOVAOneWay(int citype, double cilevel, int cntrl,
                           int n, int r, double *y, 
                           double *b, double *bse, double *bcil, double *bciu,
                           double *dm, double *dmse, double *dmcil, double *dmciu,
                           double *dmdf, double *dmt, double *dmp, int *dmsig, double *dmalpha,
                           double *anova, double *mtest,
                           double *mws, double *dfadj);

/* Two-way ANOVA, One repeated variable */
int NAGRepeatedANOVATwoWayOneRV(int interaction, int citype, double cilevel, int cntrl1, int cntrl2,
                                int n, int r, double *y, int nlx, int *x, 
                                double *b1, double *b1se, double *b1cil, double *b1ciu,
                                double *b2, double *b2se, double *b2cil, double *b2ciu,
                                double *b3, double *b3se, double *b3cil, double *b3ciu,
                                double *dm1, double *dm1se, double *dm1cil, double *dm1ciu, 
                                double *dm1df, double *dm1t, double *dm1p, int *dm1sig, double *dm1alpha,
                                double *dm2, double *dm2se, double *dm2cil, double *dm2ciu,
                                double *dm2df, double *dm2t, double *dm2p, int *dm2sig, double *dm2alpha,
                                double *di1, double *di1se, double *di1cil, double *di1ciu,
                                double *di1df, double *di1t, double *di1p, int *di1sig, double *di1alpha,
                                double *di2, double *di2se, double *di2cil, double *di2ciu,
                                double *di2df, double *di2t, double *di2p, int *di2sig, double *di2alpha,
                                double *anova, double *mtest, double *mws, double *dfadj);

/* Two-way ANOVA, Two repeated variables */
int NAGRepeatedANOVATwoWayTwoRV(int interaction, int citype, double cilevel, int cntrl1, int cntrl2,
                                int n, int r, double *y, int nlx1, int nlx2, 
                                double *b1, double *b1se, double *b1cil, double *b1ciu,
                                double *b2, double *b2se, double *b2cil, double *b2ciu,
                                double *b3, double *b3se, double *b3cil, double *b3ciu,
                                double *dm1, double *dm1se, double *dm1cil, double *dm1ciu, 
                                double *dm1df, double *dm1t, double *dm1p, int *dm1sig, double *dm1alpha,
                                double *dm2, double *dm2se, double *dm2cil, double *dm2ciu,
                                double *dm2df, double *dm2t, double *dm2p, int *dm2sig, double *dm2alpha,
                                double *di1, double *di1se, double *di1cil, double *di1ciu,
                                double *di1df, double *di1t, double *di1p, int *di1sig, double *di1alpha,
                                double *di2, double *di2se, double *di2cil, double *di2ciu,
                                double *di2df, double *di2t, double *di2p, int *di2sig, double *di2alpha,
                                double *anova, double *mtest, double *mws, double *dfadj);
// End RM ANOVA				////
////////////////////////////////

//////////////////////////////////////////////////////////
// Begin Wavelets:
/// ML 11/10/2005 ORGONAG_DLL
//#include	<nag8\nag_wav.h>
/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE
//#ifdef __AFX_H__	   //VC
/// end NEW_NAG_WAVELET_UPDATE

#include	"nag_wav.h"

#else // !__AFX_H__

#include	<nag8\nag_wav.h>

#endif // !__AFX_H__

/// end ORGONAG_DLL
// End Wavelets				////
////////////////////////////////

/// ML 11/10/2005 ORGONAG_DLL
#ifdef __AFX_H__	   //VC
#ifdef __cplusplus
}
#endif

#endif // __AFX_H__
/// end ORGONAG_DLL



/////////////////////////////////////
#endif //!_OC_NAG_EX_H


